/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh   mesh;
Matrix matrix;
/******************************************************************************/
void InitPre()
{
   App.name="Separate parts rendering";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.mode(800,600);
   Cam.dist=3;
}
/******************************************************************************/
Bool Init()
{
   mesh.create(3); // create mesh with room for 3 parts
  
   // setup #0
   {
      Mshc &C=mesh.C(0);
      C.B.create(Ball(0.7),VTX_TX0|VTX_NRM|VTX_TNG); // create Mshb
      C.setMaterial(Materials("mtrl/brick/0.mtrl")); // set material
      Set(C.name,"ball");                            // set name
   }

   // setup #1
   {
      Mshc &C=mesh.C(1);
      C.B.create(Tube(0.3,3),VTX_TX0|VTX_NRM|VTX_TNG); // create Mshb
      C.setMaterial(Materials("mtrl/glass/0.mtrl"));   // set material
      Set(C.name,"tube");                              // set name
   }

   // setup #2
   {
      Mshc &C=mesh.C(2);
      C.B.create(Box(3,0.3,0.3),VTX_TX0|VTX_NRM|VTX_TNG); // create Mshb
      C.setMaterial(Materials("mtrl/grass/0.mtrl"));      // set material
      Set(C.name,"box");                                  // set name
   }

   mesh.setRender().setBox(); // setup mesh rendering version and bounding box
   matrix.setPos(Vec(0,0,1)); // setup object matrix with position (0,0,1)

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01f,10,CAMH_ZOOM|(Ms.b(1) ? CAMH_MOVE : CAMH_ROT));
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear();
   LightDir(1,Cam.matrix.z).set();
   
   if(!Kb.b(KB_SPACE)) // if space not pressed
   {
      mesh.draw(matrix); // render all parts with one object matrix
   }else
   {
      // when space pressed render each part separately with different matrix
      {
         Char *name[]=
         {
            "tube",
            "box",
         };
         mesh.showAll().hide(name,ELMS(name)).draw(matrix); // render all parts EXCEPT those listed in 'names'
      }
      {
         Matrix local_transformation;
                local_transformation.setRotateX(Tm.time()/2);
         mesh.hideAll().show("tube").draw(local_transformation*matrix); // render ONLY those parts that are named "tube"
      }
      {
         Matrix local_transformation;
                local_transformation.setRotateZ(Tm.time()/2);
         mesh.hideAll().show("box").draw(local_transformation*matrix); // render ONLY those parts that are named "box"
      }
      mesh.showAll(); // remember to un-hide all elements after separate parts rendering
   }
   
   D.text(0,0.8,"Hold space to render each part with different matrix");
}
/******************************************************************************/
